define([
    'underscore',
    'backbone',
    'marionette',
    'App',
    'modules/page/popup/popup-view',
    'modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice-section-view', // eslint-disable-line max-len
    'modules/new-appointment-wizard/wizard-step-model',
    'text!modules/community-care-request/new-appointment-request-question/preferred-provider/choices/choice-layout.html', // eslint-disable-line max-len
    'modules/page/popup/external-nav-popup-view',
],
function(
    _,
    Backbone,
    Marionette,
    app,
    PopupView,
    ChoiceSection,
    WizardStepModel,
    template,
    ExternalNavigationWarningPopup
) {
    'use strict';

    return Marionette.View.extend({
        className: 'view',
        template: _.template(template),
        events: _.extend({}, PopupView.prototype.events, {
            'popupafterclose': 'queuePopupOrDestroy',
            'click .external-link': 'openExternalLink',
        }),
        childViewEvents: {
            'provider:add': 'showAdditionalProvider',
            'provider:delete': 'deleteProvider',
        },
        regions: {
            preferredProvider1: '.primary-provider1',
            preferredProvider2: '.primary-provider2',
            preferredProvider3: '.primary-provider3',
        },
        initialize: function(options) {
            if (_.isUndefined(options)) {
                this.model = new WizardStepModel.Model();
            } else {
                this.model = options.model;
            }

            if (!this.model.get('preferredProviders')) {
                this.model.set('preferredProviders', new Backbone.Collection(new Backbone.Model({ 'id': 1 })));
            }
        },
        showAdditionalProvider: function() {
            var newRegionIndex = this.model.get('preferredProviders').length + 1;
            var newProvider = 'preferredProvider' + newRegionIndex;
            var newProviderSectionView;
            this.model.get('preferredProviders').add(new Backbone.Model({ 'id': newRegionIndex }));
            newProviderSectionView = new ChoiceSection({
                model: this.model,
                id: newRegionIndex,
            });
            
            this.showChildView(newProvider, newProviderSectionView);
        },
        deleteProvider: function(providerChoiceId) {
            var MAX_REGIONS = 3;

            var region;
            var newProviderSectionView;
            var regionIndex;


            this.model.get('preferredProviders').remove(this.model.get('preferredProviders').get(providerChoiceId));
            
            // clear out all regions
            for (regionIndex = 1; regionIndex <= MAX_REGIONS; regionIndex++) {
                region = this.getRegion('preferredProvider' + regionIndex);
                region.empty();
            }

            // update regions with new model and id changes
            this.model.get('preferredProviders').each(function(value, index) {
                var newId = index + 1;
                var regionToReShow = 'preferredProvider' + newId;

                // update the model id to be the new index in the list offset by 1 to match length
                var preferredProvider = this.model.get('preferredProviders').at(index);
                preferredProvider.set('id', newId);

                newProviderSectionView = new ChoiceSection({
                    model: this.model,
                    id: newId,
                });
                this.showChildView(regionToReShow, newProviderSectionView);
            }.bind(this));
        },
        queuePopupOrDestroy: function() {
            if (!this._preventDestroy) {
                this.destroy();
            } // else retain popup-view to show after cancelling opening external link
        },
        templateContext: function() {
            return {
                approvedProvidersLink: app.externalLinks.get('approved-providers').toJSON(),
            };
        },
        onRender: function() {
            this.model.get('preferredProviders').each(function(value) {
                var preferredProviderChoice = new ChoiceSection({
                    model: this.model,
                    id: value.get('id'),
                });
                var region = 'preferredProvider' + value.get('id');
                this.showChildView(region, preferredProviderChoice);
            }.bind(this));
        },
        hideDeleteBtn: function() {
            this.$el.find('.delete-provider > button').hide();
        },
        openExternalLink: function(e) {
            var $link;
            var navigationWarning;

            e.preventDefault();

            $link = $(e.currentTarget);
            navigationWarning = new (ExternalNavigationWarningPopup.extend({focusOnElAfterClose: _.noop}))({
                elAfterClose: $link,
                model: new Backbone.Model({href: $link.attr('href')}),
            });
            navigationWarning.openPopup();
        },
    });
});
